<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://"
			+ request.getServerName() + ":" + request.getServerPort()
			+ path + "/";
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!-- 
	我的考试
	Liusx
	2015/08/13
 -->
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<base href="<%=basePath%>"/>
	<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/mta/css/myExam.css" />
</head>
<body>
	<div id="header">
		<c:import url="header.jsp"></c:import>
	</div>
	<div id="personalMain" class="w">
		<div id="leftNav" class="l">
			<c:import url="personalCenter.jsp"></c:import>
		</div>
		<div id="mainRight" class="r">
			<div class="title">
				<span class="title_back l"></span>
				<h2 class="l">
					<!--我的考试 -->
					<spring:message code="label.center.myexam"/>
				</h2>
			</div>
			<div class="right_nav" id="examDl">
				<span class="l">
					<!--状态： -->
					<spring:message code="label.center.status"/>
				</span>
				<ul class="list l">
					<!-- 全部 -->
					<li id="selectedExam_0" class="l active"><spring:message code="combobox.all"/></li>
					<!-- 未报名 -->
					<li id="selectedExam_4" class="l"><spring:message code="label.font.kszt4"/></li>
					<!-- 报名审核中 -->
					<li id="selectedExam_5" class="l"><spring:message code="label.font.kszt5"/></li>
					<!-- 即将开始-->
					<li id="selectedExam_1" class="l"><spring:message code="label.font.kczt3"/></li>
					<!-- 正在考试-->
					<li id="selectedExam_2" class="l"><spring:message code="label.font.kszt2"/></li>
					<!-- 已结束 -->
					<li id="selectedExam_3" class="l"><spring:message code="label.font.kczt4"/></li>
				</ul>
			</div>
			<table id="examList" width="830" cellspacing="0" cellpadding="0" border="0">
				<thead>
					<tr>
						<!-- 编号 -->
						<th width="150" colspan="2"><spring:message code="label.center.number"/></th>
						<!-- 考试名称 -->
						<th width="140"><spring:message code="label.center.examname"/></th>
						<!-- 开始时间 -->
						<th width="140"><spring:message code="label.center.starttime"/></th>
						<!-- 结束时间 -->
						<th width="140"><spring:message code="label.center.endtime"/></th>
						<!-- 总分 -->
						<th width="80"><spring:message code="label.center.totalscore"/></th>
						<!-- 得分 -->
						<th width="80"><spring:message code="label.center.defen"/></th>
						<!-- 操作 -->
						<th width="100"><spring:message code="lable.shijuan.manage"/></th>	
					</tr>
				</thead>
				<tbody>
				</tbody>
			</table>
			<div class="numb" id="examPage">
				<%@include file="page.jsp" %>
			</div>
		</div>
	</div>
	<div id="footer">
		<c:import url="footer.jsp"></c:import>
	</div>		
</body>
	<script src="<%=request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript" language="javascript"></script>
	<script type="text/javascript">
		var language="<%=session.getAttribute("language")%>"; 
		if (language.indexOf('en') > -1) {
			document.write("<script src='" + baseUrl + "/resources/js/mta_en/P030Exam.js'><\/script>");
		} else {
			// 默认中文
			document.write("<script src='" + baseUrl + "/resources/js/mta/P030Exam.js'><\/script>");
		}
	</script>
</html>